class Room
  attr_reader :path
  attr_reader :graphic

  attr_accessor :x
  attr_accessor :y

  def initialize(args, name, tiles = [[]], floor_color = Color::LIGHTYELLOW)
    @args = args
    @transitioning = false

    @name = name
    @tiles = tiles.reverse

    @background_color = Color::LIGHTYELLOW
    @path = name

    @x = 0
    @y = 0

    @floor_color = floor_color
  end

  def w
    @args.outputs[@path].w
  end
  def h
    @args.outputs[@path].h
  end

  def tick(args = nil)
    return unless @transitioning
    args = @args if args.nil?
  end

  def draw_graphic
    output = []
    # @args.outputs[@path].w = @args.state.room_width
    # @args.outputs[@path].h = @args.state.room_height

    output << {x: 0, y: 0, w: w, h: h, path: :pixel}.merge(@floor_color)

    @tiles.map_2d do |col, row, tile|
      color = case tile
      when 0
        Color::BLACK.merge({a: 0})
      when 1
        Color::GREEN
      end
      output << {x: row * 32, y: col * 32, w: 32, h: 32, **color, path: :pixel}
    end

    output
  end

  def reset_position()
    @x = 0
    @y = 0
  end

  def draw(args = nil)
    args = @args if args.nil?
    args.outputs[@path]
  end

  def graphic
    @args.outputs[@path].w = @args.state.room_width
    @args.outputs[@path].h = @args.state.room_height
    @args.outputs[@path].transient = true

    @args.outputs[@path].primitives << draw_graphic

    @args.outputs[@path].primitives
  end
end